# -*- coding: utf-8 -*-

from django.shortcuts import render_to_response
from django.http import HttpResponseRedirect
from forms import LoginForm, StudentProfileForm, EmployeeProfileForm
from Trombinoscoop.models import Personne, Etudiant, Employe, Message
import datetime

from django.db import connection

def get_logged_user_from_request(request):
  if 'logged_user_id' in request.session:
    logged_user_id = request.session['logged_user_id']
    # On cherche un étudiant
    if len(Etudiant.objects.filter(id=logged_user_id)) == 1:
      return Etudiant.objects.get(id=logged_user_id)
    # On cherche un Employé
    elif len(Employe.objects.filter(id=logged_user_id)) == 1:
      return Employe.objects.get(id=logged_user_id)
    # Si on n'a rien trouvé
    else:
      return None
  else:
    return None

def welcome(request):
  logged_user = get_logged_user_from_request(request)
  if logged_user:
    if 'newMessage' in request.GET and request.GET['newMessage'] != '':
      newMessage = Message(auteur=logged_user,
                           contenu=request.GET['newMessage'],
                           date_de_publication =  datetime.date.today())
      newMessage.save()
      
    friendMessages = Message.objects.filter(auteur__amis=logged_user).order_by('-date_de_publication')
    
    return render_to_response('welcome.html', 
                              {'logged_user': logged_user,
                               'friendMessages': friendMessages})
  else:
    return HttpResponseRedirect('/login')

def login(request):
  # Test si formulaire a été envoyé
  if len(request.GET) > 0:
    form = LoginForm(request.GET)
    if form.is_valid():
      user_email = form.cleaned_data['email']
      logged_user = Personne.objects.get(courriel=user_email)
      request.session['logged_user_id'] = logged_user.id
      return HttpResponseRedirect('/welcome')
    else:
      return render_to_response ('login.html', {'form': form})
  # Le formulaire n'a pas été envoyé
  else:
    form = LoginForm()
    return render_to_response ('login.html', {'form': form})
  
def register(request):
  if len(request.GET) > 0:
    form = StudentProfileForm(request.GET)
    if form.is_valid():
      form.save(commit=True)
      return HttpResponseRedirect('/login')
    else:
      return render_to_response ('login.html', {'form': form})
  else:
    form = StudentProfileForm()
    return render_to_response ('user_profile.html', {'form': form})


def register2(request):
  if len(request.GET) > 0 and 'profileType' in request.GET:
    studentForm = StudentProfileForm(prefix="st")
    employeeForm = EmployeeProfileForm(prefix="em")
    if request.GET['profileType'] == 'student':
      studentForm = StudentProfileForm(request.GET, prefix="st")
      if studentForm.is_valid():
        studentForm.save(commit=True)
        return HttpResponseRedirect('/login')
    elif request.GET['profileType'] == 'employee':
      employeeForm = EmployeeProfileForm(request.GET, prefix="em")
      if employeeForm.is_valid():
        employeeForm.save(commit=True)
        return HttpResponseRedirect('/login')
    # Le formulaire envoyé n'est pas valide
    return render_to_response('user_profile2.html', 
                               {'studentForm': studentForm, 
                                'employeeForm': employeeForm})
  else: 
    studentForm = StudentProfileForm(prefix="st")
    employeeForm = EmployeeProfileForm(prefix="em")
    return render_to_response('user_profile2.html', 
                               {'studentForm': studentForm, 
                                'employeeForm': employeeForm})